<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Blog extends Model
{
    protected $fillable = [
        'title', 'description','image','blog_status','date','link'
    ];
    
    public static function fileAttribute($file,$blog_id){

        if(is_file($file)){
            $folder = public_path().'/images/blog/';

            $ext = $file->getClientOriginalExtension();
            $fileName = time() . "_" . "blog" . "." . $ext;
            $path = 'images/blog/'.$fileName;

            if ($blog_id != null){
                $blog = Blog:: where ('id',$blog_id)->first();
                if (file_exists(public_path().$blog->image)){

                    unlink(public_path().$blog->image);
                }

            }
            $pathDestination = $folder;
            if(!file_exists($folder)){
                mkdir($folder, 0777, true);
                $file->move($pathDestination, $fileName);
            }else{
                $file->move($pathDestination, $fileName);
            }

            return $path;
        }else{
            return null;
        }
    }
}
