<?php

namespace App\Http\Controllers;
use App\Blog;
use Carbon\Carbon;
use Session;
use Redirect;
use Illuminate\Http\Request;
use App\Http\Requests\BlogRequest;

class BlogController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $blogs = Blog::all();
        return view('blog.index', compact('blogs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('blog.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(BlogRequest $request)
    {
       
        $blogs = new Blog();

        $blogs->image = Blog::fileAttribute($request->file('image'), null);
        $blogs->title = $request->input('title');
        $blogs->link = $request->input('link');
        $blogs->description = $request->input('description');
        $blogs->blog_status = 0;
        $blogs->date = Carbon::parse($request['date'])->format('Y-m-d');
        $blogs->save();

        Session::flash('message','Blog creado correctamente.');
        return Redirect::to('/blog');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $blog = Blog::find($id);
        return view('blog.edit', compact('blog'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(BlogRequest $request, $id)
    {
        $blog = Blog::find($id);

        if ($request->hasfile('image')) {
            $blog->image = Blog::fileAttribute($request->file('image'), $blog->id);
        }

        $blog->title = $request['title'];
        $blog->link = $request['link'];
        $blog->description = $request['description'];
        $blog->date = Carbon::parse($request['date'])->format('Y-m-d');
        $blog->update();

     
        Session::flash('message','Blog actualizado correctamente.');
        return Redirect::to('/blog');
        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $blog = Blog::find($id);


        if(isset($blog->image)) {
            if (file_exists(public_path()  . $blog->image)) {
                unlink(public_path() . $blog->image);
            }
        }
        $blog->delete();

        Session::flash('message', 'El blog se ha eliminado correctamente.');
    }

    public function changestatusblog(Request $request)
    {

        $id = $request['id'];
        $status = $request ['status'] == 'true' ? 1:0;
        $blog = Blog::find($id);

        $blog->blog_status = $status;

        $blog-> update();
        Session::flash('message','Estatus cambiado correctamente');
    }
}
