@extends("layouts.master")
@section("styles")
    {!! Html::style("/assets/css/main.css") !!}
@endsection

@section('breadcrumb')
    <div class="page-bar">
        @include('partials.request')
        <ul class="page-breadcrumb">
            <li>
                <a href="{!!URL::to('/')!!}">Inicio</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a href="{!!URL::to('/users')!!}">Usuarios</a>
                <i class="fa fa-circle"></i>
            </li>
            <li>
                <a>Editar usuario</a>
            </li>
        </ul>
    </div>
@endsection

@section("page-content")
    <div class="row content_container">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light portlet-fit bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <span class="caption-subject bold">Editar usuario</span>
                    </div>
                </div>
                <div class="portlet-body">
                    {!! Form::model($user,['route' => ['users.update', $user->id], 'method' => 'PUT', 'class' => 'form-horizontal', 'files' => true]) !!}

                    <input type="hidden" name="_token" value="{{ csrf_token() }}" id="token">
                    @include("user.form")
                    {!!Form::close()!!}
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection

@section("scripts")
    {!! Html::script("/assets/scripts/validateFields.js") !!}

    <script type="application/javascript">
        $(document).ready(function(){
            $("#liUsr").addClass("active");
        });
    </script>
@endsection