<?php $__env->startSection("styles"); ?>
  <?php echo Html::style("/assets/global/plugins/datatables/datatables.min.css"); ?>

  <?php echo Html::style("/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.css"); ?>

  <?php echo Html::style("/assets/css/main.css"); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
  <?php echo $__env->make('partials.message', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
  <div class="page-bar">
    <ul class="page-breadcrumb">
      <li>
        <a href="<?php echo URL::to('/'); ?>">Inicio</a>
        <i class="fa fa-circle"></i>
      </li>
      <li>
        <a href="<?php echo URL::to('/categories'); ?>">Categorias</a>
      </li>
    </ul>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("page-content"); ?>
  <div class="row content_container">
    <div class="col-md-12">
      <!-- BEGIN EXAMPLE TABLE PORTLET-->
      <div class="portlet light portlet-fit bordered">
        <div class="portlet-title">
          <div class="row">
            <div class="col-md-6"> <span class="caption-subject bold" style="font-size: 16px; color:gray">Categorias</span></div>
            <div class="col-md-6">
              <div class="btn-group pull-right">
                <a href="<?php echo e(URL::route('categories.create')); ?>" class="btn green"><i class="fa fa-plus"></i> Nueva Categoria</a>
              </div>
            </div>
          </div>
        </div>
        <div class="portlet-body">
          <table class="table table-striped table-hover table-bordered" id="sample_editable_1">
            <thead>
            <tr>
              <th class="center" style="display: none">ID</th>
              <th class="center">Nombre</th>
              <th class="center">Acciones</th>
            </tr>
            </thead>

            <tbody>
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td class="center" style="display: none"> <?php echo e($category->id); ?> </td>
                <td class="center"> <?php echo e($category->name); ?> </td>
                <td>
               
                  <a href="<?php echo e(URL::route('categories.edit', $category->id)); ?>" title="Editar" class="btn btn-icon-only green-meadow ">
                    <i class="fa fa-edit"></i>
                  </a>
                  <a href="#basic" data-toggle="modal" data-name="<?php echo e($category->name); ?>" data-id="<?php echo e($category->id); ?>" title="Eliminar" class="btn btn-icon-only red modalDelete">
                    <i class="fa fa-times"></i>
                  </a>
                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
        </div>
      </div>
      <!-- END EXAMPLE TABLE PORTLET-->
    </div>
  </div>

  <div class="modal fade" id="basic" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title">Eliminar categoria</h4>
        </div>
        <div class="modal-body" id="bodyDelete">

        </div>
        <div class="modal-footer">
          <input type="hidden" name="_token" value="<?php echo e(csrf_token()); ?>" id="token">
          <button type="button" class="btn green-meadow" data-dismiss="modal" onclick="deleteUser()">Aceptar</button>
          <button type="button" class="btn red " data-dismiss="modal"></i>Cancelar</button>
        </div>
      </div>
      <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
  </div>
  <!-- /.modal -->
<?php $__env->stopSection(); ?>

<?php $__env->startSection("scripts"); ?>
  <?php echo Html::script("/assets/global/scripts/datatable.js"); ?>

  <?php echo Html::script("/assets/global/plugins/datatables/datatables.min.js"); ?>

  <?php echo Html::script("/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"); ?>

  <?php echo Html::script("/assets/scripts/simplified_datatable.js"); ?>

  <script type="application/javascript">
    $(document).ready(function(){
      $("#liCat").addClass("active");
     /* table = $('#sample_editable_1').DataTable( {
        paging: false
      } );

      table.destroy();

      table = $('#sample_editable_1').DataTable( {
        searching: false,
        order: [[0, 'asc']]
      } );*/

     /* $('#sample_editable_1').DataTable({
        order: [[0, 'asc']]
      });*/
    });

    $(".modalDelete").click(function(){
      id = $(this).data("id");
      var name = $(this).data("name");
      var nodeName=document.createElement("p");
      var nameNode=document.createTextNode("¿Seguro que desea eliminar la categoría?");
      nodeName.appendChild(nameNode);
      $("#bodyDelete").empty();
      document.getElementById("bodyDelete").appendChild(nodeName);
    });

    function deleteUser(){
      var token = $("#token").val();

      $.ajax({
        url: "categories/"+id+"",
        headers: {'X-CSRF-TOKEN': token},
        type: "DELETE",
        success: function() {
          window.location = "/categories";
          $("#message").fadeIn();
        }
      });
    }
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>