<?php $__env->startSection("styles"); ?>
  <?php echo Html::style("/assets/global/plugins/datatables/datatables.min.css"); ?>

  <?php echo Html::style("/assets/css/main.css"); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
  <?php echo $__env->make('partials.message', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
  <div class="page-bar">
    <ul class="page-breadcrumb">
      <li>
        <a href="<?php echo URL::to('/'); ?>">Inicio</a>
        <i class="fa fa-circle"></i>
      </li>
      <li>
        <a href="<?php echo URL::to('/services'); ?>">Servicios</a>
      </li>
    </ul>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("page-content"); ?>
  <div class="row content_container">
    <div class="col-md-12">
      <!-- BEGIN EXAMPLE TABLE PORTLET-->
      <div class="portlet light portlet-fit bordered">
        <div class="portlet-title">
          <div class="row">
            <div class="col-md-6"> <span class="caption-subject bold" style="font-size: 16px; color:gray">Servicios</span></div>
            <div class="col-md-6">
              
            </div>
          </div>
        </div>
        <div class="portlet-body">
          <table class="table table-striped table-hover table-bordered" id="sample_editable_1">
            <thead>
            <tr>
              <th class="center">Nombre</th>
              <th class="center">Imagen</th>
              <th class="center">Acciones</th>
            </tr>
            </thead>

            <tbody>
            <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td class="center"> <?php echo e($service->name); ?> </td>
                <td class="center"><img src="<?php echo e($service->image); ?>" alt="banner" height="75"/></td>
                <td>
                  <a href="<?php echo e(URL::route('services.edit', $service->id)); ?>" title="Editar" class="btn btn-icon-only green-meadow ">
                    <i class="fa fa-edit"></i>
                  </a>
                </td>
              </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
          </table>
        </div>
      </div>
      <!-- END EXAMPLE TABLE PORTLET-->
    </div>
  </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection("scripts"); ?>
  <?php echo Html::script("/assets/global/scripts/datatable.js"); ?>

  <?php echo Html::script("/assets/global/plugins/datatables/datatables.min.js"); ?>

  <?php echo Html::script("/assets/global/plugins/datatables/plugins/bootstrap/datatables.bootstrap.js"); ?>

  <?php echo Html::script("/assets/scripts/simplified_datatable.js"); ?>

  <script type="application/javascript">
    $(document).ready(function(){
      $("#liSer").addClass("active");
    });
  </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("layouts.master", array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>